import time
import subprocess
import json
import requests
from requests.auth import HTTPBasicAuth
import time

f = open("apikey", "r")
global apikey
apikey = f.read().strip("\n")


def launch_instance(id, price, disk, script, dockerimg):
    url = f"https://vast.ai/api/v0/asks/{id}/?api_key=" + apikey
    params = {"client_id": id, "image": dockerimg, "price": price, "disk": disk}

    if script:
        params["onstart"] = script

    r = requests.put(url, json)
    try:
        retval = r.json()["success"]
    except BaseException:
        return False

    return retval


def destroy_instance(id):

    url = f"https://vast.ai/api/v0/instances/{id}/?api_key=" + apikey
    r = requests.delete(url, json={})
    r.raise_for_status()

    if r.status_code == 200:
        rj = r.json()
        if rj["success"]:
            return True
        else:
            return False
    else:
        return False


def start_instance(id):
    url = f"https://vast.ai/api/v0/instances/{id}/?api_key=" + apikey
    r = requests.put(url, json={"state": "running"})
    r.raise_for_status()

    if r.status_code == 200:
        rj = r.json()
        if rj["success"]:
            return True
        else:
            return False
    else:
        return False


def stop_instance(id):
    url = f"https://vast.ai/api/v0/instances/{id}/?api_key=" + apikey
    r = requests.put(url, json={"state": "stopped"})
    r.raise_for_status()

    if r.status_code == 200:
        rj = r.json()
        if rj["success"]:
            return True
        else:
            return False
    else:
        return False


def is_running(id):

    rdata = requests.get(
        """https://vast.ai/api/v0/instances?owner=me&api_key=720b988c57c5989a9009092f65146d0195fff4d8f09a94575c96ec14e107a3de"""
    )
    maclist = rdata.json()["instances"]
    for instance in maclist:
        if instance["id"] == id:
            if instance["cur_state"] == "running":
                return True

    return False


###################################################

# TODO: should not have this if we're going to have an instance class.
def list_my_instances():
    url = f"https://vast.ai/api/v0/machines?owner=me&api_key=" + apikey
    r = requests.get(url)
    r.raise_for_status()
    machines = r.json()["machines"]
    return machines


# have similar lists for everything.
def list_available_instances():
    rdata = requests.get(
        """https://vast.ai/api/v0/bundles?q=%7B%22verified%22%3A+%7B%22eq%22%3A+true%7D%2C+%22external%22%3A+%7B%22eq%22%3A+false%7D%2C+%22rentable%22%3A+%7B%22eq%22%3A+true%7D%2C+%22order%22%3A+%5B%5B%22score%22%2C+%22desc%22%5D%5D%2C+%22type%22%3A+%22on-demand%22%7D&api_key="""
        + apikey
    )
    maclist = rdata.json()["offers"]
    mac = maclist[0]
    maclist = [dict(mac, provider="vastai") for mac in maclist]
    return maclist


# test = list_available_instances()
# print(test[0])
