import time
import subprocess
import json
import datacrunch
import requests
from requests.auth import HTTPBasicAuth
import time
import vast
import datacrunchwrap
import uuid


class Instance:
    def __init__(self, provider: str):
        self.provider = provider
        self.running = False
        self.instance = None
        self.dcinstance = None
        self.dc_client = datacrunchwrap.dc_client
        self.tflops = None
        self.price = None
        self.dcname = None

    def is_running(self) -> bool:
        prov = self.provider
        if prov == "vastai":
            return vast.is_running(self.instance["id"])

        elif prov == "datacrunch":
            return self.dcinstance.status == self.dc_client.instance_status.RUNNING

    def is_launching(self) -> bool:
        prov = self.provider
        if prov == "datacrunch":
            return self.dcinstance.status == self.dc_client.instance_status.PROVISIONING

    def launch_instance(self, machinedict:dict, name:str, script:str) -> str: 
        #TODO: deploy nodes from here, also pass node priority for buffer instances.
        provider = self.provider

        if provider == "vastai":
            self.tflops = (
                self.calc_tflops(machinedict["gpu_name"]) * machinedict["num_gpus"]
            )
            self.instance = machinedict
            self.price = machinedict["dph_total"]
            # vast.launch_instance(machinedict["id"])
            return "launched"

        elif provider == "datacrunch":
            self.tflops = (
                self.calc_tflops(machinedict["gpu_name"]) * machinedict["num_gpus"]
            )
            self.instance = machinedict
            self.price = machinedict["dph_total"]
            self.dcinstance = "fuck."
            self.dcname = str(uuid.uuid4())
            try:
                self.dcinstance = datacrunchwrap.launch_instance(machinedict["instance_type"], self.dcname)
                return True
            except:
                return False
            print("Launched a datacrunch server.")
            return True

        else:
            print("WHY THERE IS NO SWITCH CASES")

    def restore_instance(self, machinedict: dict):
        provider = self.provider
        if provider == "datacrunch":
            self.tflops = self.calc_tflops(machinedict["gpu_name"]) * machinedict["num_gpus"]
            self.instance = machinedict
            self.price = machinedict["dph_total"]
            self.dcinstance = machinedict["dcinstance"]
            self.dcname = self.dcinstance.hostname
        
        elif provider == "vastai":
            self.tflops = (
                self.calc_tflops(machinedict["gpu_name"]) * machinedict["num_gpus"]
            )
            self.instance = machinedict
            self.price = machinedict["dph_total"]


    def destroy_instance(self) -> None:
        provider = self.provider
        if provider == "vastai":
            vast.destroy_instance(self.machine_id)
        elif provider == "datacrunch":
            datacrunchwrap.destroy_instance(self.dcinstance.id)

    def stop_instance(self) -> None:
        provider = self.provider

        if provider == "vastai":
            vast.stop_instance

    # TODO: Change this to TFLOPS?
    def calc_tflops(self, gpu_name):
        gpu_tflops = {
            "RTX 2080 Ti": 26,
            "Tesla V100": 28,
            "A100 PCIE": 78,
            "Tesla P100": 20,
            "RTX 2080": 20,
            "RTX 3090": 35,
            "RTX A6000": 40,
        }
        tflops = gpu_tflops[gpu_name]
        return tflops
