import grpc
import sys
import pathlib
import interfaces.gooseai.completion.completion_pb2 as completion

thisPath = str(pathlib.Path(__file__).parent.resolve())
sys.path.append(thisPath + "/interfaces/gooseai/completion")

import interfaces.gooseai.completion.completion_pb2_grpc as completion_grpc


def client():
    print("Opening channel")
    channel = grpc.insecure_channel('localhost:50051')
    stub = completion_grpc.CompletionServiceStub(channel)
    print("Channel opened")
    rq = completion.Request(
        prompt=[
            completion.Prompt(text="The witch laughed"),
            completion.Prompt(text="The warlock laughed")
        ],
        engine_params=completion.EngineParams(
            echo=completion.Echo(),
            completions=1,
            max_tokens=100))
    print("Completion called")
    lastCompletionId = None
    for resp in stub.Completion(rq):
        if lastCompletionId != resp.answer_id:
            print("")
            lastCompletionId = resp.answer_id
        print(resp.choices[0].text, end="")


def main():
    client()


if __name__ == "__main__":
    main()
