#!/bin/sh

# Arguments
BUILD=${1:-"dev"}
TARGET=${2:-"local"}
# shift args out for later call
if [ $# -eq 1 ]; then
    shift 
elif [ $# -ge 2 ]; then
    shift 2
fi

TAG=$(echo "${GITHUB_SHA:-$(git rev-parse HEAD)}" | cut -c -7)

# Docker Values
IMAGE_REPO=gooseai/hydra-node
if [ "$BUILD" = "dev" ]; then
    IMAGE_REPO=gooseai/hydra-node-dev
fi

# Docker build / publish
if [ "$TARGET" = "local" ]; then
    docker build . -t $IMAGE_REPO:$TAG -t $IMAGE_REPO $@
else
    docker build . -t $IMAGE_REPO:$TAG $@
    docker push . -t $IMAGE_REPO:$TAG
fi 

